# Calibrate controls
Manage profiles and fine-tune calibration for controllers, optimize the sensitivity of steering, throttle, and brakes.

## Connected devices

## Input calibration

### Steering sensitivity
Make the steering more or less responsive around the center of the wheel.

### Steering deadzone
Add a buffer to the center of the steering wheel. Adding more deadzone makes the buffer until input starts to register greater.

### Throttle sensitivity
Make the throttle more or less responsive.

### Brake sensitivity
Make the brake more or less responsive.

### Clutch sensitivity
Make the clutch more or less responsive.

## Force feedback settings

### Type
Select the type of steering device

### Smoothing
Adding smoothing to the force feedback helps when force feedback feels too grainy. Keep in mind that adding smoothing will also remove the smaller details of the force feedback signal.

### Car specific multiplier
Set a force feedback multiplier specific to the currently selected car.

### Minimum steering torque
A higher value will help reduce the "dead" feeling of the force feedback around the center of steering, especially with weaker steering wheels. Strong direct-drive FFB wheels should work best with a value of 0.0%.

### Force feedback strength
Force feedback strength across all cars. Some steering wheels interpret the force feedback signal inverted, in which case set this number to a negative value in order to align the direction of the force feedback signal from rFactor 2 with your steering wheel.


## Steering settings

### Rotation limit mode
When set to software, allows rFactor 2 to adjust the wheel rotation per car even for wheels that don't support setting the rotation in their driver.

If setting this to software, you should also set your rotation in your wheel driver to the maximum it supports (up to 1440 degrees that rFactor 2 supports), if possible.

The last step is to set the "Default max wheel angle" to the same value as in the driver.

### Max wheel angle mode
When set to automatic, this will try to read the steering wheel rotation from the wheel driver. On some wheels this will fail, and you should set this setting to custom and set the "Default max wheel angle" manually.

### Default max wheel angle
Default maximum wheel angle to use when not read from driver, from 40 to 1440 degrees. See the "Rotation limit mode" setting for more information.

### Range set by vehicle
If enabled, the steering wheel range is automatically set to the value defined by the current vehicle.

### Steering wheel range
Degrees of steering wheel rotation, both visual and physical. This setting is disabled if "Range set by vehicle" setting is enabled.

### Steering rate
How fast the car steering will follow player input. Higher rates make the car more snappy, whereas lower rates make the car less reactive.

### Return rate multiplier
Steering rate multiplier for returning to the center. Higher values make the car react faster when letting go and correcting than it reacts to turn in, allowing for quick reactions without making the car twitchy.

### Snap factor
How snappy the steering rate is going to be. At 0%, it will slowly ease towards the input even at high steering rates. At 100%, it will barely ease at all, while still respecting the overall steering rate. This can be used to use a low steering rate in order to make the car less twitchy while still having precise control with smaller steering movements.

### Filter type
Type of steering filter to use. The modern approach helps the ability to fine control movement within the maximum acceptable slip angles of the front tyres, while simulating the feeling of force feedback. The classic approach is simple speed sensitivity that scales down steering sensitivity based on speed, without simulating any feedback. Use the modern option if you want to get feedback from the car, or the classic option if you prefer the car to simply follow your input.

### Steering aggression
This setting will control how aggressively the car will turn in. Higher values will cause a more twitchy car that overdrives the front tyres, whereas lower values will make the car more controllable at the cost of potentially using less of the available grip.

### Speed sensitivity
A higher value will slow down your steering more as you gain speed. The default setting is 0%, but if you find the steering too twitchy at high speed, you can try increasing the value.

### Exaggerate yaw
Values other than 0.0% will turn the driving camera more or less to the direction of the car movement.

With a negative value, if the rear of the car steps out, the camera will turn to look into the direction the rear is stepping out to. A positive value will turn the camera to the other direction.

0.0% is a good starting point, but this setting is a personal preference so you should try to experiment with it to see if it can make you feel the car handling better.

### Look ahead
A higher value will turn the driving camera more into the direction you're steering to. A value of 0.0% is recommended, especially if you have wide or triple screens, or VR.

### Head physics
A higher value will move the cockpit view around more based on the forces acting on the driver.

### Head vibration
The type of effects that will vibrate the cockpit view.
